/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.tiered;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicHull;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_Diode
extends GT_MetaTileEntity_BasicHull {
    private long maxAmps;
    private long aAmps;

    public GT_MetaTileEntity_Diode(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, StatCollector.translateToLocal((String)"tooltip.tile.diode.0.name"), new ITexture[0]);
        this.aAmps = this.maxAmps = this.getAmpsfromMeta(aID);
    }

    public GT_MetaTileEntity_Diode(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (this.maxAmps == 0L && !this.getBaseMetaTileEntity().getWorld().isRemote) {
            this.aAmps = this.maxAmps = this.getAmpsfromMeta(this.getBaseMetaTileEntity().getMetaTileID());
        }
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        if (this.getBaseMetaTileEntity().getWorld().isRemote) {
            return;
        }
        if (!aPlayer.isSneaking()) {
            --this.aAmps;
            if (this.aAmps < 0L) {
                this.aAmps = this.maxAmps;
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Max Amps: " + this.aAmps));
        } else {
            ++this.aAmps;
            if (this.aAmps > this.maxAmps) {
                this.aAmps = 0L;
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Max Amps: " + this.aAmps));
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.setLong("maxAmp", this.maxAmps);
        aNBT.setLong("Amps", this.aAmps);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.maxAmps = aNBT.getLong("maxAmp");
        this.aAmps = aNBT.getLong("Amps");
        super.loadNBTData(aNBT);
    }

    public long maxAmperesOut() {
        return this.aAmps;
    }

    public long maxAmperesIn() {
        return this.aAmps;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Diode(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    private long getAmpsfromMeta(int meta) {
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 2) {
            return 2L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 2 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 3) {
            return 4L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 3 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 4) {
            return 8L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 4 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 5) {
            return 12L;
        }
        if (meta > ConfigHandler.IDOffset + GT_Values.VN.length * 5 && meta <= ConfigHandler.IDOffset + GT_Values.VN.length * 6) {
            return 16L;
        }
        return 0L;
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, StatCollector.translateToLocal((String)"tooltip.tile.tiereddsc.0.name") + " " + "\u00a7e" + GT_Values.V[this.mTier], StatCollector.translateToLocal((String)"tooltip.tile.tiereddsc.1.name") + " " + "\u00a7e" + this.maxAmperesIn(), StatCollector.translateToLocal((String)"tooltip.tile.tiereddsc.2.name") + " " + "\u00a7e" + this.maxAmperesOut(), StatCollector.translateToLocal((String)"tooltip.bw.1.name") + "\u00a72" + " BartWorks"};
    }
}

